<?php
//include("datos_sistema.php");

// Datos de autenticación
//$apiKey = 'qW7bNV37Po';
//$apiSecret = '29b754syvx';


function AltiriaSMS($sDestination, $sMessage, $sSenderId = '', $debug = false) {
    // URL base de los recursos REST
    $baseUrl = 'https://www.altiria.net:8443/apirest/ws/sendSms';
    
    // Credenciales de autenticación
    $credentials = [
        'apiKey' => 'qW7bNV37Po',      // Sustituir por tu API Key
        'apiSecret' => '29b754syvx'    // Sustituir por tu API Secret
    ];
    
    // Verificación de parámetros
    if (empty($sDestination) || empty($sMessage)) {
        throw new Exception('El número de destino y el mensaje son obligatorios.');
    }
    
    // Dividir destinos si hay múltiples números separados por coma
    $destinations = array_map('trim', explode(',', $sDestination));
    
    // Construcción del mensaje
    $jsonMessage = [
        'msg' => mb_substr($sMessage, 0, 160), // Límite de 160 caracteres
    ];
    
    // Agregar remitente si es válido (no aplicable en América)
    if (!empty($sSenderId)) {
        $jsonMessage['senderId'] = $sSenderId;
    }
    
    $jsonData = [
        'credentials' => $credentials,
        'destination' => $destinations,
        'message' => $jsonMessage
    ];
    
    // Inicializar cURL
    $ch = curl_init($baseUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($jsonData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json;charset=UTF-8']);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // Tiempo máximo para conectar
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);      // Tiempo máximo de respuesta
    
    // Ejecutar solicitud y manejar respuesta
    $response = curl_exec($ch);
    $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    // Manejo de errores de cURL
    if ($curlError) {
        throw new Exception('Error cURL: ' . $curlError);
    }
    
    // Manejo de errores HTTP
    if ($statusCode != 200) {
        throw new Exception('Error HTTP: ' . $statusCode . ' - ' . $response);
    }
    
    // Parsear la respuesta de Altiria
    $responseData = json_decode($response, true);
    if ($responseData['status'] !== '000') {
        throw new Exception('Error de Altiria: ' . $responseData['status'] . ' - ' . $responseData['errorMessage']);
    }
    
    if ($debug) {
        echo "Respuesta completa de Altiria:\n";
        print_r($responseData);
    }
    
    return $responseData;
}

// Ejemplo de uso
try {
    $response = AltiriaSMS('56991826690', 'Mensaje de prueba VectorWeb', '', true);
    echo "¡Mensaje enviado con éxito! Respuesta:\n";
    print_r($response);
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}

?>
